#!/sbin/sh

export MODPATH
export KSU_VER
export KSU_KERNEL_VER
export PRODUCT_DEVICE
CORE_FILE="$MODPATH/core"
TMP_SCRIPT="$MODPATH/${MODULE_ID}_temp.sh"

if [ ! -f "${CORE_FILE}" ]; then
    echo "error: Core file does not exist"
    exit 1
fi

base64 -d "${CORE_FILE}" > "${TMP_SCRIPT}"
if [ $? -ne 0 ]; then
    echo "error: Core file corruption"
    rm -f "${TMP_SCRIPT}"
    exit 1
fi
chmod 700 "${TMP_SCRIPT}"

. "${TMP_SCRIPT}"
EXEC_STATUS=$?

rm -f "${TMP_SCRIPT}"

if [ ${EXEC_STATUS} -ne 0 ]; then
    echo "error: Core file internal error"
    exit ${EXEC_STATUS}
fi
exit 0
